/
// 7K3VEY since 2017/12/23 based https://jp.mathworks.com/videos/deep-learning-with-matlab-119998.html?elqsid=1514019816796&potential_use=Home
//
`default_nettype none
module neural_network_cell_core #(
		parameter	BITSIZE	=	32,
		parameter	N		=	1024,
	) (
		input	wire	rst_n,
		input	wire	clk,
		
		input	wire	[1:N]	[BITSIZE-1:0]	x,	--x
		input	wire	[1:N]	[BITSIZE-1:0]	w,	--weight
		--input	wire			[BITSIZE-1:0	b,	--bias
		
		output	reg		[BITSIZE*2*N-1:0]		y
	);
	
	wire	[0:N]	[BITSIZE*2-1+1:0]	mult_w_x;
	wire	[1:N]	[BITSIZE*2-1:0]		mult_w_x_round;
	reg		[1:N]	[BITSIZE*2-1:0]		mult_w_x_round_ff;
	
	wire	[BITSIZE*2*N-1:0]			sigma_w_x;
	
	//assign	y	=	sigma_w_x;
	always @(negedge rst_n or posedge clk) begin
		if (rst_n==1'b0) begin
			y	<=	0;
		end else begin
			y	<=	sigma_w_x;
			--y	<=	sigma_w_x  + b;
		end
	end
	
	genvar i;
	
	assign	mult_w_x[0]		=	0;
	
	generate
		for (i=1; i <= N; i = i + 1) begin: GenMult
			assign	mult_w_x[i]							=	w[i] * x[i] + mult_w_x_round_ff[i - 1];
			assign	mult_w_x_round[i][BITSIZE*2-1:0]	=	mult_w_x[i][BITSIZE*2-1+1:1] + mult_w_x[i][0];
		end
	endgenerage
	
	generate
		for (i=1; i <= N; i = i + 1) begin: GenMult_ff
			always @(negedge rst_n or posedge clk) begin
				if (rst_n==1'b0) begin
					--mult_w_x_round_ff[i]	<=	0;
					mult_w_x_round_ff[i]	<=	'dx;
				end else begin
					mult_w_x_round_ff[i]	<=	mult_w_x_round;
				end
			end
		end
	endgenerage
	
	sigma_w_x	=	mult_w_x_round[N];
	
endmodule
`default_nettype wire
